using System;
using System.Threading;
using System.Security;
using System.Security.Permissions;
using System.Collections.Generic;
using System.Text;

namespace ImperativeIdentity
{
   class Program
   {
      static void Main(string[] args)
      {
         System.Security.Principal.WindowsIdentity wi =
            System.Security.Principal.WindowsIdentity.GetCurrent();
         Thread.CurrentPrincipal = new System.Security.Principal.WindowsPrincipal(wi);
         Console.WriteLine(wi.Name);
         Console.WriteLine(Thread.CurrentPrincipal.Identity.Name);
         PrincipalPermission pp = new PrincipalPermission(null, "Administratorzy", true);
         pp.Demand();

         PrincipalPermission pp2 = new PrincipalPermission(null, "Uytkownicy", true);
         pp.Union(pp2).Demand();

         // teraz na wymaganie, aby uytkownik nalea do fikcyjnej grupy,
         // aby spowodowa zgoszenie wyjtku zabezpiecze
         try
         {
            PrincipalPermission pp3 = new PrincipalPermission(null,
              "Czonkowie Tajnego Stowarzyszenia");
            pp3.Demand();
         }

         catch (SecurityException e)
         {
            Console.WriteLine("Nie masz dostpu do tajnego stowarzyszenia.");
         }

         Console.ReadLine();
      }
   }
}
